/* SCE CONFIDENTIAL
* PlayStation(R)3 Programmer Tool Runtime Library 430.001
* Copyright (C) 2012 Sony Computer Entertainment Inc.
* All Rights Reserved.
*/

#ifndef _SCE_PS3_COND_VAR_H
#define _SCE_PS3_COND_VAR_H

#include "condition_variable.h"
#include "ps3_mutex.h"
#include <sys/synchronization.h>

namespace sce {
	namespace Toolkit{
		namespace NP{
			namespace Utilities {
		/// @brief
		/// Class implementing the ConditionVariable interface.
		///
		/// This class implements the ConditionVariable by using the methods
		/// of sys_cond_t from the PS3 SDK. It also includes methods to lock
		/// the queue so that the condition can't be used during initialisation.
		class ConditionVariableImpl : public ConditionVariable {
		public:
			/// @brief
			/// Implementation of Abstract method to initialise object.
			///
			/// Implementation of Abstract method to initialise object.
			/// @return Returns SUCCESS or a generic error value.
			int init();
			/// @brief
			/// Implementation of Abstract method to terminate object.
			///
			/// Implementation of Abstract method to terminate object.
			/// @return Returns SUCCESS or a generic error value.
			int term();
			/// @brief
			/// Implementation of Abstract method to signal to a thread waiting on this condition.
			///
			/// Implementation of Abstract method to signal to a thread waiting on this condition.
			/// Which thread is signaled if there is a queue depends on implementation.
			/// @return Returns SUCCESS or a generic error value.
			int signal(); ///< order depends on when the scheduling algorithm of the mutex
			/// @brief
			/// Implementation of Abstract method to signal all threads waiting on this condition.
			///
			/// Implementation of Abstract method to signal all threads waiting on this condition.
			/// @return Returns SUCCESS or a generic error value.
			int	signalAll();
			/// @brief
			/// Implementation of Abstract method to wait on this object
			///
			/// Implementation of Abstract method to wait on this object
			/// @param time The time in milliseconds to wait before returning a timeout error.
			/// @return Returns SUCCESS or a generic error value.
			virtual int wait(unsigned int time) const;
			/// @brief
			/// Implementation of Abstract method to lock the underlying object.
			///
			/// Implementation of Abstract method to lock the underlying object.
			/// This implementation should use a FIFO queue.
			/// @return Returns SUCCESS or a generic error value.
			int lock();
			/// @brief
			/// Implementation of Abstract method to unlock the underlying object.
			///
			/// Implementation of Abstract method to unlock the underlying object.
			/// @return Returns SUCCESS or a generic error value.
			int unlock();
			//virtual int signalTo(Thread& waiting); ///< possible addition for different thread objects all waiting on the same condition.
		private:
			MutexImpl m_mutex;
			sys_cond_t	m_cond;
		};

			}//end Utilities
		}//end NP
	}//end Toolkit
}//end sce
#endif
